/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.info;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.info.ActionLimitation;
import com.alrex.parcool.common.network.LimitationByServerMessage;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LimitationByServer {
    private boolean haveReceived = false;
    private boolean enforced = false;
    private int maxStaminaLimitation = Integer.MAX_VALUE;
    private int maxStaminaRecovery = Integer.MAX_VALUE;
    private boolean infiniteStaminaPermitted = true;
    private final ActionLimitation[] list = new ActionLimitation[ActionList.ACTIONS.size()];

    public LimitationByServer() {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i] = new ActionLimitation(true, 0);
        }
    }

    public boolean isReceived() {
        return this.haveReceived;
    }

    public boolean isPermitted(Class<? extends Action> action) {
        if (!this.haveReceived) {
            return false;
        }
        if (!this.enforced) {
            return true;
        }
        ActionLimitation limitation = this.list[ActionList.getIndexOf(action)];
        if (limitation == null) {
            return false;
        }
        return limitation.isPossible();
    }

    public int getLeastStaminaConsumption(Class<? extends Action> action) {
        if (!this.haveReceived) {
            return 0;
        }
        if (!this.enforced) {
            return 0;
        }
        ActionLimitation limitation = this.list[ActionList.getIndexOf(action)];
        if (limitation == null) {
            return 0;
        }
        return limitation.getLeastStaminaConsumption();
    }

    public int getMaxStaminaLimitation() {
        if (!this.enforced) {
            return Integer.MAX_VALUE;
        }
        return this.maxStaminaLimitation;
    }

    public int getMaxStaminaRecovery() {
        if (!this.enforced) {
            return Integer.MAX_VALUE;
        }
        return this.maxStaminaRecovery;
    }

    public boolean isInfiniteStaminaPermitted() {
        return !this.enforced || this.infiniteStaminaPermitted;
    }

    public void writeSyncData(LimitationByServerMessage msg) {
        msg.setEnforced(this.enforced);
        msg.setMaxStaminaLimitation(this.maxStaminaLimitation);
        msg.setPermissionOfInfiniteStamina(this.infiniteStaminaPermitted);
        msg.setMaxStaminaRecovery(this.maxStaminaRecovery);
        ActionLimitation[] limitations = msg.getLimitations();
        for (int i = 0; i < ActionList.ACTIONS.size(); ++i) {
            limitations[i] = new ActionLimitation(this.list[i].isPossible(), this.list[i].getLeastStaminaConsumption());
        }
    }

    public Tag writeTag() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("enforced", this.enforced);
        nbt.m_128405_("max_stamina", this.maxStaminaLimitation);
        nbt.m_128379_("infinite_stamina_permitted", this.infiniteStaminaPermitted);
        ListTag limitationList = new ListTag();
        for (int i = 0; i < this.list.length; ++i) {
            ActionLimitation limitation = this.list[i];
            if (limitation == null) continue;
            Class<? extends Action> action = ActionList.getByIndex(i);
            CompoundTag actionNbt = new CompoundTag();
            actionNbt.m_128359_("action_name", action.getSimpleName());
            actionNbt.m_128379_("action_permitted", limitation.isPossible());
            actionNbt.m_128405_("action_stamina_consumption", limitation.getLeastStaminaConsumption());
            limitationList.add((Object)actionNbt);
            nbt.m_128344_("list_type", limitationList.m_7264_());
        }
        nbt.m_128365_("actions", (Tag)limitationList);
        return nbt;
    }

    public void readTag(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbt;
            this.enforced = compoundTag.m_128471_("enforced");
            this.maxStaminaLimitation = compoundTag.m_128451_("max_stamina");
            this.infiniteStaminaPermitted = compoundTag.m_128471_("infinite_stamina_permitted");
            for (Tag inbt : compoundTag.m_128437_("actions", (int)compoundTag.m_128445_("list_type"))) {
                int i;
                if (!(inbt instanceof CompoundTag)) continue;
                CompoundTag actionNbt = (CompoundTag)inbt;
                String name = actionNbt.m_128461_("action_name");
                for (i = 0; i < ActionList.ACTIONS.size() && !name.equals(ActionList.getByIndex(i).getSimpleName()); ++i) {
                }
                if (i == ActionList.ACTIONS.size()) continue;
                this.list[i] = new ActionLimitation(actionNbt.m_128471_("action_permitted"), actionNbt.m_128451_("action_stamina_consumption"));
            }
        } else {
            throw new IllegalArgumentException("Tag for LimitationByServer, is not CompoundTag");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receive(LimitationByServerMessage msg) {
        this.haveReceived = true;
        this.enforced = msg.isEnforced();
        this.maxStaminaLimitation = msg.getMaxStaminaLimitation();
        this.maxStaminaRecovery = msg.getMaxStaminaRecovery();
        this.infiniteStaminaPermitted = msg.getPermissionOfInfiniteStamina();
        for (int i = 0; i < ActionList.ACTIONS.size(); ++i) {
            this.list[i] = msg.getLimitations()[i];
        }
    }

    public static class IndividualLimitationChanger {
        @Nullable
        LimitationByServer instance = null;
        ServerPlayer player;

        public IndividualLimitationChanger(ServerPlayer player) {
            Parkourability parkourability = Parkourability.get((Player)player);
            this.player = player;
            if (parkourability != null) {
                this.instance = parkourability.getActionInfo().getIndividualLimitation();
            }
        }

        public IndividualLimitationChanger setDefault() {
            if (this.instance == null) {
                return this;
            }
            this.instance.maxStaminaLimitation = Integer.MAX_VALUE;
            this.instance.enforced = false;
            this.instance.infiniteStaminaPermitted = true;
            for (int i = 0; i < this.instance.list.length; ++i) {
                this.instance.list[i] = new ActionLimitation(true, 0);
            }
            return this;
        }

        public IndividualLimitationChanger setMaxStaminaLimitation(int value) {
            if (this.instance == null) {
                return this;
            }
            this.instance.maxStaminaLimitation = value;
            return this;
        }

        public IndividualLimitationChanger setEnforced(boolean value) {
            if (this.instance == null) {
                return this;
            }
            this.instance.enforced = value;
            return this;
        }

        public IndividualLimitationChanger setInfiniteStaminaPermission(boolean value) {
            if (this.instance == null) {
                return this;
            }
            this.instance.infiniteStaminaPermitted = value;
            return this;
        }

        public IndividualLimitationChanger setPossibilityOf(Class<? extends Action> action, boolean value) {
            if (this.instance == null) {
                return this;
            }
            ActionLimitation limitation = this.instance.list[ActionList.getIndexOf(action)];
            this.instance.list[ActionList.getIndexOf(action)] = new ActionLimitation(value, limitation.getLeastStaminaConsumption());
            return this;
        }

        public IndividualLimitationChanger setStaminaConsumptionOf(Class<? extends Action> action, int value) {
            if (this.instance == null) {
                return this;
            }
            ActionLimitation limitation = this.instance.list[ActionList.getIndexOf(action)];
            this.instance.list[ActionList.getIndexOf(action)] = new ActionLimitation(limitation.isPossible(), value);
            return this;
        }

        public void sync() {
            if (this.instance == null) {
                return;
            }
            LimitationByServerMessage.sendIndividualLimitation(this.player);
        }
    }
}

